




/**
 ******************************************************************************
 *
 * @file      BSP_TouchKey.c
 * @brief     The file is Touch key H code. 
 *
 * @par       Project
 *            MG32
 * @version   V1.00
 * @date      2022/03/02
 * @author    Megawin Software Center
 * @copyright Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *            All rights reserved.
 * 
 ******************************************************************************* 
 * @par Disclaimer
 * The Demo software is provided "AS IS" without any warranty, either
 * expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and fitness for a particular purpose. The author will
 * not be liable for any special, incidental, consequential or indirect
 * damages due to loss of data or any other reason.
 * These statements agree with the world wide and local dictated laws about
 * authorship and violence against these laws.
 *******************************************************************************
 *******************************************************************************
 */
 
#include "MG32.h"
#include "BSP_Common_MG04_06.h"
#include "MG32_ADC_DRV.h"
#include "MG32_TM_DRV.h"
 
 /** 
 * @name  Define 
 */                                                      
///@{

/*GPIO*/
#define TOUCHKEY_PWM0_IOM     PINC(13)
#define TOUCHKEY_PWM0_AFS     7

#define TOUCHKEY_PWM1_IOM     PINC(14)
#define TOUCHKEY_PWM1_AFS     7

#define TOUCHKEY_AIN0_IOM     PINA(9)
#define TOUCHKEY_AIN1_IOM     PINA(10)


#define TOUCHKEY_AIN0_Channel 9              /*!< ADC scan to use channel2*/
#define TOUCHKEY_AIN1_Channel 10              /*!< ADC scan to use channel3*/


#define TOUCHKEY_ERROR_DEFAULT_DATA_MAI      0x01
#define TOUCHKEY_ERROR_DEFAULT_DATA_MAX      0x02




// Timer counter value define
#define TK_TM0x_MAIN       0x04
#define TK_TM0x_PRE        0x47

#define Scan_Time          4
#define ADCx_SMP_CNT       5

#define TK_Basic_Default   0x0916               // VDD = Vref, Vpin = 2.84V
#define TK_Data_Boundary   0x0E66               // VDD = Vref, Vpin = 4.50V
#define TK_HappenMAX       0x0051               // Vadc deference(0.10V) ADC Code = Vin*4096/5
#define TK_HappenMIN       0x023D               // Vadc deference(0.70V)

#define Scan_TK0            PB0
#define Scan_TK1            PB1
#define Scan_TK2            PB2
#define Scan_TK3            PB3


#define TK_NKEY             0x0000
#define TK_KEY0F            0x0001
#define TK_KEY1F            0x0002
#define TK_KEY2F            0x0004
#define TK_KEY3F            0x0008



///@}


/** 
 * @name  typedef 
 */                                                      
///@{

/*! @enum   Scan_KeyTypeDef
    @brief  Scan Touch key line.
*/
typedef enum {
    Scan_PAD0 = 0,
    Scan_PAD1 = 1,
    Scan_PAD2 = 2,
    Scan_PAD3 = 3,
}Scan_KeyTypeDef;


/*! @struct Touch_ConfigTypeDef
    @brief  Touch key control
*/
typedef struct {
    uint16_t    KEY_STA;
    uint16_t    TK_ADCx_DAT[2];
    uint16_t    Touch_Basic_Data0[3];
    uint16_t    Touch_Basic_Data1[3];
    uint16_t    TK_DEF_DAT[2];
    uint16_t    TK_DAT_MIN_CH0;
    uint16_t    TK_DAT_MAX_CH0;
    uint16_t    TK_DAT_MIN_CH1;
    uint16_t    TK_DAT_MAX_CH1;
    uint8_t     Scan_Key;
    uint8_t     ERR_STA;
}Touch_ConfigTypeDef;


///@}

/** 
 * @name  Varables 
 */                                                      
///@{

extern Touch_ConfigTypeDef TK_CONF;



/** 
 * @name  Function Delcare 
 */                                                      
///@{

void BSP_TouchKey_InitCallback(void);


void BSP_TouchKey_Init(void);
uint16_t API_TouchKey_GetStatus(void);
void API_TouchKeyCharge_Cmd(FunctionalState Charge_Cmd);

///@}
 
 


























